//
//  CRImageWell.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 6/21/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

@class CRTexture;

//////////////////////////////////////////////////////////////////////
// Image well with image path support (including thus path from the
// bunlde resources)
//////////////////////////////////////////////////////////////////////
@interface CRImageWell : CRControl
{
@private
	BOOL				border;

@public
	CRTexture*			texture;
	NSDictionary*		mapping;
	NSImage*			imageThumbnail;
}

@property (nonatomic, assign)	BOOL			acceptDrop;
@property (nonatomic, assign)	BOOL			border;
@property (nonatomic, strong)	CRTexture*		texture;
@property (nonatomic, copy)		NSDictionary*	mapping;
@property (assign)				BOOL			isUpdating;

- (NSRect)imageRect;
- (void)setImagePath:(NSString *)path;

+ (void)cleanupQueue;

@end